'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var mesh = require('@pixi/mesh');
var RopeGeometry = require('./geometry/RopeGeometry.js');

class SimpleRope extends mesh.Mesh {
  constructor(texture, points, textureScale = 0) {
    const ropeGeometry = new RopeGeometry.RopeGeometry(texture.height, points, textureScale);
    const meshMaterial = new mesh.MeshMaterial(texture);
    if (textureScale > 0) {
      texture.baseTexture.wrapMode = core.WRAP_MODES.REPEAT;
    }
    super(ropeGeometry, meshMaterial);
    this.autoUpdate = true;
  }
  _render(renderer) {
    const geometry = this.geometry;
    if (this.autoUpdate || geometry._width !== this.shader.texture.height) {
      geometry._width = this.shader.texture.height;
      geometry.update();
    }
    super._render(renderer);
  }
}

exports.SimpleRope = SimpleRope;
//# sourceMappingURL=SimpleRope.js.map
