'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var core = require('@pixi/core');
var mesh$1 = require('./shader/mesh.js');
var mesh = require('./shader/mesh2.js');

class MeshMaterial extends core.Shader {
  constructor(uSampler, options) {
    const uniforms = {
      uSampler,
      alpha: 1,
      uTextureMatrix: core.Matrix.IDENTITY,
      uColor: new Float32Array([1, 1, 1, 1])
    };
    options = Object.assign({
      tint: 16777215,
      alpha: 1,
      pluginName: "batch"
    }, options);
    if (options.uniforms) {
      Object.assign(uniforms, options.uniforms);
    }
    super(options.program || core.Program.from(mesh["default"], mesh$1["default"]), uniforms);
    this._colorDirty = false;
    this.uvMatrix = new core.TextureMatrix(uSampler);
    this.batchable = options.program === void 0;
    this.pluginName = options.pluginName;
    this._tintColor = new core.Color(options.tint);
    this._tintRGB = this._tintColor.toLittleEndianNumber();
    this._colorDirty = true;
    this.alpha = options.alpha;
  }
  get texture() {
    return this.uniforms.uSampler;
  }
  set texture(value) {
    if (this.uniforms.uSampler !== value) {
      if (!this.uniforms.uSampler.baseTexture.alphaMode !== !value.baseTexture.alphaMode) {
        this._colorDirty = true;
      }
      this.uniforms.uSampler = value;
      this.uvMatrix.texture = value;
    }
  }
  set alpha(value) {
    if (value === this._alpha)
      return;
    this._alpha = value;
    this._colorDirty = true;
  }
  get alpha() {
    return this._alpha;
  }
  set tint(value) {
    if (value === this.tint)
      return;
    this._tintColor.setValue(value);
    this._tintRGB = this._tintColor.toLittleEndianNumber();
    this._colorDirty = true;
  }
  get tint() {
    return this._tintColor.value;
  }
  get tintValue() {
    return this._tintColor.toNumber();
  }
  update() {
    if (this._colorDirty) {
      this._colorDirty = false;
      const baseTexture = this.texture.baseTexture;
      const applyToChannels = baseTexture.alphaMode;
      core.Color.shared.setValue(this._tintColor).premultiply(this._alpha, applyToChannels).toArray(this.uniforms.uColor);
    }
    if (this.uvMatrix.update()) {
      this.uniforms.uTextureMatrix = this.uvMatrix.mapCoord;
    }
  }
}

exports.MeshMaterial = MeshMaterial;
//# sourceMappingURL=MeshMaterial.js.map
