'use strict';

var _const = require('./const.js');

const _SegmentPacker = class {
  constructor() {
    this.strideFloats = 12;
    this.bufferPos = 0;
    this.indexPos = 0;
  }
  updateBufferSize(jointStart, jointLen, triangles, target) {
    const { joints } = target;
    let foundTriangle = false;
    let vertexSize = 0;
    let indexSize = 0;
    for (let i = jointStart; i < jointStart + jointLen; i++) {
      const prevCap = joints[i] & ~31;
      const joint = joints[i] & 31;
      if (joint === _const.JOINT_TYPE.FILL) {
        foundTriangle = true;
        vertexSize++;
        continue;
      }
      if (joint >= _const.JOINT_TYPE.FILL_EXPAND) {
        vertexSize += 3;
        indexSize += 3;
        continue;
      }
      const vs = _SegmentPacker.vertsByJoint[joint] + _SegmentPacker.vertsByJoint[prevCap];
      if (vs >= 4) {
        vertexSize += vs;
        indexSize += 6 + 3 * Math.max(vs - 6, 0);
      }
    }
    if (foundTriangle) {
      indexSize += triangles;
    }
    target.vertexSize += vertexSize;
    target.indexSize += indexSize;
  }
  beginPack(buildData, bufFloat, bufUint, indices, bufferPos = 0, indexPos = 0) {
    this.buildData = buildData;
    this.bufFloat = bufFloat;
    this.bufUint = bufUint;
    this.indices = indices;
    this.bufferPos = bufferPos;
    this.indexPos = indexPos;
  }
  endPack() {
    this.buildData = null;
    this.bufFloat = null;
    this.bufUint = null;
    this.indices = null;
  }
  packInterleavedGeometry(jointStart, jointLen, triangles, lineStyle, color) {
    const { bufFloat, bufUint, indices, buildData, strideFloats } = this;
    const { joints, verts: verts2 } = buildData;
    let bufPos = this.bufferPos;
    let indPos = this.indexPos;
    let index = this.bufferPos / this.strideFloats;
    let x1;
    let y1;
    let x2;
    let y2;
    let prevX;
    let prevY;
    let nextX;
    let nextY;
    let hasTriangle = false;
    let travel = 0;
    for (let j = jointStart; j < jointStart + jointLen; j++) {
      const fullJoint = joints[j];
      const prevCap = joints[j] & ~31;
      const joint = joints[j] & 31;
      if (joint === _const.JOINT_TYPE.FILL) {
        hasTriangle = true;
        x1 = verts2[j * 2];
        y1 = verts2[j * 2 + 1];
        bufFloat[bufPos] = x1;
        bufFloat[bufPos + 1] = y1;
        bufFloat[bufPos + 2] = x1;
        bufFloat[bufPos + 3] = y1;
        bufFloat[bufPos + 4] = x1;
        bufFloat[bufPos + 5] = y1;
        bufFloat[bufPos + 6] = x1;
        bufFloat[bufPos + 7] = y1;
        bufFloat[bufPos + 8] = travel;
        bufFloat[bufPos + 9] = 16 * joint;
        bufFloat[bufPos + 10] = lineStyle;
        bufUint[bufPos + 11] = color;
        bufPos += strideFloats;
        continue;
      }
      if (joint >= _const.JOINT_TYPE.FILL_EXPAND) {
        prevX = verts2[j * 2];
        prevY = verts2[j * 2 + 1];
        x1 = verts2[j * 2 + 2];
        y1 = verts2[j * 2 + 3];
        x2 = verts2[j * 2 + 4];
        y2 = verts2[j * 2 + 5];
        const bis = j + 3;
        for (let i = 0; i < 3; i++) {
          bufFloat[bufPos] = prevX;
          bufFloat[bufPos + 1] = prevY;
          bufFloat[bufPos + 2] = x1;
          bufFloat[bufPos + 3] = y1;
          bufFloat[bufPos + 4] = x2;
          bufFloat[bufPos + 5] = y2;
          bufFloat[bufPos + 6] = verts2[(bis + i) * 2];
          bufFloat[bufPos + 7] = verts2[(bis + i) * 2 + 1];
          bufFloat[bufPos + 8] = travel;
          bufFloat[bufPos + 9] = 16 * fullJoint + i;
          bufFloat[bufPos + 10] = lineStyle;
          bufUint[bufPos + 11] = color;
          bufPos += strideFloats;
        }
        indices[indPos] = index;
        indices[indPos + 1] = index + 1;
        indices[indPos + 2] = index + 2;
        indPos += 3;
        index += 3;
        continue;
      }
      const vs = _SegmentPacker.vertsByJoint[joint] + _SegmentPacker.vertsByJoint[prevCap];
      if (vs === 0) {
        continue;
      }
      x1 = verts2[j * 2];
      y1 = verts2[j * 2 + 1];
      x2 = verts2[j * 2 + 2];
      y2 = verts2[j * 2 + 3];
      prevX = verts2[j * 2 - 2];
      prevY = verts2[j * 2 - 1];
      const dist = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
      if (_SegmentPacker.vertsByJoint[joint] === 0) {
        travel -= dist;
      }
      if ((joint & ~2) !== _const.JOINT_TYPE.JOINT_CAP_BUTT) {
        nextX = verts2[j * 2 + 4];
        nextY = verts2[j * 2 + 5];
      } else {
        nextX = x1;
        nextY = y1;
      }
      for (let i = 0; i < vs; i++) {
        bufFloat[bufPos] = prevX;
        bufFloat[bufPos + 1] = prevY;
        bufFloat[bufPos + 2] = x1;
        bufFloat[bufPos + 3] = y1;
        bufFloat[bufPos + 4] = x2;
        bufFloat[bufPos + 5] = y2;
        bufFloat[bufPos + 6] = nextX;
        bufFloat[bufPos + 7] = nextY;
        bufFloat[bufPos + 8] = travel;
        bufFloat[bufPos + 9] = 16 * fullJoint + i;
        bufFloat[bufPos + 10] = lineStyle;
        bufUint[bufPos + 11] = color;
        bufPos += strideFloats;
      }
      travel += dist;
      indices[indPos] = index;
      indices[indPos + 1] = index + 1;
      indices[indPos + 2] = index + 2;
      indices[indPos + 3] = index;
      indices[indPos + 4] = index + 2;
      indices[indPos + 5] = index + 3;
      indPos += 6;
      for (let j2 = 5; j2 + 1 < vs; j2++) {
        indices[indPos] = index + 4;
        indices[indPos + 1] = index + j2;
        indices[indPos + 2] = index + j2 + 1;
        indPos += 3;
      }
      index += vs;
    }
    if (hasTriangle) {
      for (let i = 0; i < triangles.length; i++) {
        indices[indPos + i] = triangles[i] + index;
      }
      indPos += triangles.length;
    }
    this.bufferPos = bufPos;
    this.indexPos = indPos;
  }
};
let SegmentPacker = _SegmentPacker;
SegmentPacker.vertsByJoint = [];
const verts = SegmentPacker.vertsByJoint;
for (let i = 0; i < 256; i++) {
  verts.push(0);
}
verts[_const.JOINT_TYPE.FILL] = 1;
for (let i = 0; i < 8; i++) {
  verts[_const.JOINT_TYPE.FILL_EXPAND + i] = 3;
}
verts[_const.JOINT_TYPE.JOINT_BEVEL] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_BEVEL + 1] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_BEVEL + 2] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_BEVEL + 3] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_ROUND] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_ROUND + 1] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_ROUND + 2] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_ROUND + 3] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_MITER] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_MITER + 1] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_MITER + 2] = 4;
verts[_const.JOINT_TYPE.JOINT_MITER + 3] = 4;
verts[_const.JOINT_TYPE.JOINT_CAP_BUTT] = 4;
verts[_const.JOINT_TYPE.JOINT_CAP_BUTT + 1] = 4;
verts[_const.JOINT_TYPE.JOINT_CAP_SQUARE] = 4;
verts[_const.JOINT_TYPE.JOINT_CAP_SQUARE + 1] = 4;
verts[_const.JOINT_TYPE.JOINT_CAP_ROUND] = 4 + 5;
verts[_const.JOINT_TYPE.JOINT_CAP_ROUND + 1] = 4 + 5;
verts[_const.JOINT_TYPE.CAP_ROUND] = 4;

exports.SegmentPacker = SegmentPacker;
//# sourceMappingURL=SegmentPacker.js.map
