import { SHAPES } from '@pixi/core';
import { CircleBuilder } from './CircleBuilder.mjs';
import { PolyBuilder } from './PolyBuilder.mjs';
import { RectangleBuilder } from './RectangleBuilder.mjs';
import { RoundedRectangleBuilder } from './RoundedRectangleBuilder.mjs';

const FILL_COMMANDS = {
  [SHAPES.POLY]: new PolyBuilder(),
  [SHAPES.CIRC]: new CircleBuilder(),
  [SHAPES.ELIP]: new CircleBuilder(),
  [SHAPES.RECT]: new RectangleBuilder(),
  [SHAPES.RREC]: new RoundedRectangleBuilder()
};

export { CircleBuilder, FILL_COMMANDS, PolyBuilder, RectangleBuilder, RoundedRectangleBuilder };
//# sourceMappingURL=index.mjs.map
