import BaseToken from"../../../common/documents/token.mjs";import ServerDocumentMixin from"../backend/server-document.mjs";import{getProperty,getType,hasProperty,setProperty}from"../../../common/utils/helpers.mjs";export default class Token extends(ServerDocumentMixin(BaseToken)){static _migrationRegistry=[...super._migrationRegistry,{fn:migrateLightConfig,version:12},{fn:migrateNegativeLightRadius,version:12},{fn:migrateGradualLightToAttenuation,version:12},{fn:migrateTextureData,version:12},{fn:migrateSight,version:12},{fn:migrateActorData,version:12},{fn:migrateZeroAngles,version:12},{fn:migrate2x2HexShape,version:12},{fn:migrateNonsquareTextureFit,version:12},{fn:migrateNullVisionRanges,version:12},{fn:migrateOcclusionRadiusFlag,version:12},{fn:migrateNegativeLuminosity,version:"12.319"},{fn:migrateTokenRing,version:"12.320"}];async _preUpdate(e,t,i){if(!1===await super._preUpdate(e,t,i))return!1;const n=t._movement?.[this.id];if(n){const a=n.destination,r=e.x??this.x,o=e.y??this.y,s=e.elevation??this.elevation,h=e.width??this.width,g=e.height??this.height,l=e.shape??this.shape;if(r!==a.x||o!==a.y||s!==a.elevation||h!==a.width||g!==a.height||l!==a.shape)return global.logger.error(`The changed position {x: ${r}, y: ${o}, elevation: ${s}, width: ${h}, height: ${g}, shape: ${l}} of Token [${this.id}] in Scene [${this.parent.id}] does not match the destination {x: ${a.x}, y: ${a.y}, elevation: ${a.elevation}, width: ${a.width}, height: ${a.height}, shape: ${a.shape}} of movement initiated by User [${i.id}]. The movement of this Token has been prevented.`),delete t._movement[this.id],!1;const c=n.origin;if(this.x!==c.x||this.y!==c.y||this.elevation!==c.elevation||this.width!==c.width||this.height!==c.height||this.shape!==c.shape)return global.logger.warn(`The current position {x: ${this.x}, y: ${this.y}, elevation: ${this.elevation}, width: ${this.width}, height: ${this.height}, shape: ${this.shape}} of Token [${this.id}] in Scene [${this.parent.id}] does not match the origin {x: ${c.x}, y: ${c.y}, elevation: ${c.elevation}, width: ${c.width}, height: ${c.height}, shape: ${c.shape}} of movement initiated by User [${i.id}]. The movement of this Token has been prevented.`),delete t._movement[this.id],!1}"_regions"in e&&(t._priorRegions??={},t._priorRegions[this.id]=this._regions)}_onUpdate(e,t,i){if(super._onUpdate(e,t,i),"object"==typeof t.worldTime){const{delta:e,...n}=t.worldTime;Number.isNumeric(e)&&db.Setting.advanceTime(e,n,i)}}static async _onDeleteOperation(e,t,i){return await db.Combat._onDeleteTokens(e,t,i),super._onDeleteOperation(e,t,i)}async loadRelatedDocuments(){this.baseActor=await db.Actor.get(this.actorId),this.delta||await this.recreateActorDelta();for(const e of Object.values(this.delta.collections))e.initialize({full:!0});this.actorLink?this.actor=this.baseActor:this.actor=this.delta?.constructor.applyDelta(this.delta,this.baseActor)}async recreateActorDelta(){return this.updateSource({delta:new db.ActorDelta({_id:this.id},{parent:this}).toObject()}),this.save()}}function migrateLightConfig(e){let t=!1;const i={dimLight:"light.dim",brightLight:"light.bright",lightAngle:"light.angle",lightColor:"light.color",lightAlpha:"light.alpha",lightAnimation:"light.animation"};for(const[n,a]of Object.entries(i)){const i=Token._addDataFieldMigration(e,n,a);t||=i}return t}function migrateNegativeLightRadius(e){const t=e.light;if("Object"!==getType(t))return!1;let i=!1;return t.dim<0&&(t.dim=Math.abs(t.dim),i=!0),t.bright<0&&(t.bright=Math.abs(t.bright),i=!0),!!i&&(t.luminosity=-1*Math.abs(t.luminosity??.5),!0)}function migrateGradualLightToAttenuation(e){const t=e.light;return"Object"===getType(t)&&("gradual"in t&&(t.attenuation=t.gradual?.5:.3,delete t.gradual,!0))}function migrateTextureData(e){const t=Token._addDataFieldMigration(e,"img","texture.src"),i=Token._addDataFieldMigration(e,"tint","texture.tint");let n=!1,a=e.texture?.scaleX??1,r=e.texture?.scaleY??1;"scale"in e&&(a=r=e.scale,setProperty(e,"texture.scaleX",e.scale),setProperty(e,"texture.scaleY",e.scale),delete e.scale,n=!0);const o=Token._addDataFieldMigration(e,"mirrorX","texture.scaleX",(e=>e.mirrorX?-Math.abs(a):Math.abs(a))),s=Token._addDataFieldMigration(e,"mirrorY","texture.scaleY",(e=>e.mirrorY?-Math.abs(r):Math.abs(r)));return t||i||n||o||s}function migrateSight(e){const t=Token._addDataFieldMigration(e,"sightAngle","sight.angle"),i=Token._addDataFieldMigration(e,"vision","sight.enabled");let n=!1;if("dimSight"in e||"brightSight"in e){const t=e.dimSight??0,i=e.brightSight??0,a=Math.max(t,i);setProperty(e,"sight.range",a),delete e.dimSight,delete e.brightSight,setProperty(e,"sight.brightness",i>=t?1:0),n=!0}return t||i||n}function migrateActorData(e){return"actorData"in e&&("delta"in e||(e.delta=e.actorData,e._id&&"Object"===getType(e.delta)&&(e.delta._id=e._id)),delete e.actorData,!0)}function migrateZeroAngles(e){let t=!1;return"Object"===getType(e.light)&&0===e.light.angle&&(e.light.angle=360,t=!0),"Object"===getType(e.sight)&&0===e.sight.angle&&(e.sight.angle=360,t=!0),t}function migrate2x2HexShape(e){return!("shape"in e)&&(2===e.width&&2===e.height?e.hexagonalShape=CONST.TOKEN_SHAPES.ELLIPSE_2:e.hexagonalShape=CONST.TOKEN_SHAPES.ELLIPSE_1,!0)}function migrateNonsquareTextureFit(e){let t;const i=e.width||1,n=e.height||1;if(i<n)t="height";else{if(!(i>n))return!1;t="width"}return setProperty(e,"texture.fit",t),!0}function migrateNullVisionRanges(e){let t=!1;if("Object"===getType(e.sight)&&null===e.sight.range&&(e.sight.range=0,t=!0),Array.isArray(e.detectionModes))for(const i of e.detectionModes)"Object"===getType(i)&&null===i.range&&(i.range=0,t=!0);return t}function migrateOcclusionRadiusFlag(e){if(!hasProperty(e,"flags.core.occlusionRadius"))return!1;const t=Number(e.flags.core.occlusionRadius);return Number.isFinite(t)&&t>0&&(e.occludable={radius:t}),delete e.flags.core.occlusionRadius,!0}function migrateTokenRing(e){const t=getProperty(e,"flags.dnd5e.tokenRing");if(!t)return!1;const{enabled:i,colors:n,effects:a,scaleCorrection:r,textures:o}=t;return e.ring={enabled:i,colors:n,effects:a,subject:{}},o&&(e.ring.subject.texture=o.subject),Number.isFinite(r)&&(e.ring.subject.scale=r),delete e.flags.dnd5e.tokenRing,!0}function migrateNegativeLuminosity(e){const t=e.light;return"Object"===getType(t)&&(t.luminosity<0&&(t.luminosity=.5,t.negative=!0,!0))}