import crypto from"node:crypto";import fs from"node:fs";import path from"node:path";import{PACKAGE_AVAILABILITY_CODES,TIMEOUTS}from"../../common/constants.mjs";import{isNewerVersion,isEmpty,fetchWithTimeout,fetchJsonWithTimeout,mergeObject,deepClone}from"../../common/utils/_module.mjs";import{PACKAGE_TYPE_MAPPING}from"./_module.mjs";import*as fields from"../../common/data/fields.mjs";import{cleanHTML}from"../database/validators.mjs";import{handleCustomSocket}from"../server/sockets.mjs";import Files from"../files/files.mjs";import PackageInstaller from"./installer.mjs";import FileDownloader from"../files/downloader.mjs";import Collection from"../../common/utils/collection.mjs";import{ReleaseData}from"../../common/config.mjs";class PackageAssetField extends fields.StringField{constructor(e={}){super(e)}static get _defaults(){return mergeObject(super._defaults,{required:!0,blank:!1,mustExist:!0,allowHTTP:!0,relativeToPackage:!0,allowedPublicDir:null})}_cast(e){return this.allowHTTP&&URL.parseSafe(e)?e:Files.standardizePath(e)}initialize(e,t,s={}){if(!t.installed||!e)return e;if(this.allowHTTP&&URL.parseSafe(e))return e;const i=t._source.id,a=global.paths,r=this.relativeToPackage?path.join(t.constructor.collection,i):"",o=[{root:a.data,directory:r}];this.allowedPublicDir&&o.push({root:a.public,directory:this.allowedPublicDir});const n=Files.resolveClientPaths(e,o,{allowHTTP:this.allowHTTP});if(!n.some((({exists:e})=>e))&&this.mustExist)throw new Error(`The file "${e}" included by ${t.constructor.type} ${i} does not exist`);return n.find((({exists:e})=>e))?.clientPath??n[0]?.clientPath}}const ServerPackageMixin=e=>{const t=class extends e{constructor(e={},s={}){super(e,s),this.locked=t.#e(this.path,this.id)}static name="ServerPackageMixin";static defineSchema(){const e=super.defineSchema();e.scripts=new fields.SetField(new PackageAssetField({allowedPublicDir:"scripts"})),e.esmodules=new fields.SetField(new PackageAssetField({allowedPublicDir:"scripts"})),e.styles.element.fields.src=new PackageAssetField;const t=e.packs.element;t.fields.path=new PackageAssetField({required:!1,allowHTTP:!1,mustExist:!1}),Object.assign(t.fields.path,{name:"path",parent:t});const s=e.languages.element;return s.fields.path=new PackageAssetField,Object.assign(s.fields.path,{name:"path",parent:s}),e}_initializeSource(e,{installed:t=!0}={}){const{logger:s}=global;try{this.constructor.migrateData(e,{installed:t})}catch(e){e.message=`Failed data migration for ${this.name}: ${e.message}`,s.warn(e)}this._unknownKeys=[];for(const t in e)this.schema.has(t)||this._unknownKeys.push(t);return this.constructor.cleanData(e,{installed:t}),this.constructor.shimData(e)}static manifestMetadataFields=["title","author","authors","url","license","readme","bugs","changelog","manifest","download","compatibility"];installed=this.installed;_unknownKeys=this._unknownKeys;get path(){return path.join(this.constructor.baseDir,this.id)}static get baseDir(){return path.join(global.paths.data,this.collection)}static get manifestFile(){return`${this.type}.json`}static cleanData(e={},t={}){const s=super.cleanData(e,t);return"string"==typeof s.description&&(s.description=cleanHTML(s.description)),s}_configure({installed:e=!0,...t}={}){this.installed=e,super._configure(t)}_initialize(e={}){super._initialize(e);for(const e of this.packs)e.absPath=path.join(global.paths.data,e.path)}static reevaluateAvailabilities(){this.packages||this.getPackages();for(const e of this.packages.values())e.availability=e.constructor.testAvailability(e)}static#e(e,t){const s=path.join(e,`${t}.lock`);return fs.existsSync(s)}vend(){const e=super.toObject(!1);return e.availability=this.availability,e.locked=this.locked,e.exclusive=this.exclusive,e.owned=this.owned,e.tags=this.tags,e.hasStorage=this.persistentStorage&&Files.getDirectorySizeSync(this.path+"/storage")>0,e}static packages;static get(e,{strict:t=!1}={}){this.packages||this.getPackages();const s=this.packages.get(e);if(!s){if(t)throw new Error(`The requested ${this.type} ${e} does not exist!`);return null}if(s.unavailable&&t)throw new Error(`The requested package ${e} is not available for use! Make sure your core software and game system are fully updated.`);return s}static getPackages({enforceCompatibility:e=!1}={}){if(this.packages)return this.packages;const t=config.files.storages.data.getDirectories(this.baseDir).reduce(((e,t)=>{const s=path.join(t,this.manifestFile);return fs.existsSync(s)&&e.push(s),e}),[]);return this.packages=t.reduce(((t,s)=>{const i=this.fromManifestPath(s);return i?(e&&i.incompatibleWithCoreVersion||t.set(i.id,i),t):t}),new Collection)}static fromManifestPath(e){const s=config.logger;let i;try{const t=this.loadLocalManifest(e);e=t.manifestPath,i=t.manifestData}catch(t){const i=`Error loading ${this.type} "${e}": ${t.message}`;return packages.warnings.add(e,{type:this.type,level:"error",message:i}),s.error(new Error(i)),null}const a=path.basename(path.dirname(e));if(i.id!==a){const e=`Invalid ${this.type} "${i.id}" detected in directory "${a}"`;return packages.warnings.add(i.id,{type:this.type,level:"error",message:e}),s.error(e),null}if(i.protected&&!global.options.debug){const a=path.join(path.dirname(e),"signature.json");try{t.#t(a,i.version)}catch(e){const t=`Invalid signature file for protected ${this.type} "${i.id}"`;return packages.warnings.add(i.id,{type:this.type,level:"error",message:t}),s.error(t),null}}let r=null;try{r=new this(i,{strict:!0,fallback:!0,installed:!0});const e=r.validationFailures.fields;if(e&&packages.warnings.add(r.id,{type:this.type,level:"warning",message:e.toString()}),r._unknownKeys.length){const e=r._unknownKeys.map((e=>`"${e}"`)).join(", ");packages.warnings.add(r.id,{type:this.type,level:"warning",message:`The "${r.title}" ${this.type}'s manifest contained the following unknown keys: ${e}`})}}catch(e){e.message=`Metadata validation failed for ${this.type} "${i.id}": ${e.message}`,packages.warnings.add(i.id,{type:this.type,level:"error",message:e.message}),s.error(e)}if(packages.warnings.has(i.id)){const e=packages.warnings.get(i.id);e.reinstallable=i.protected||!!URL.parseSafe(i.manifest),e.manifest=i.manifest}return r}static loadLocalManifest(e){return{manifestPath:e,manifestData:JSON.parse(fs.readFileSync(e,"utf-8"))}}static async fromRemoteManifest(e,{strict:t=!0}={}){const s={404:`No ${this.type} manifest found at ${e}`,401:`Access to ${this.type} manifest at ${e} is unauthorized`,403:`Access to ${this.type} manifest at ${e} is forbidden`,500:`The server at ${e} failed to respond with ${this.type} manifest data`};let i,a;const r={timeoutMs:TIMEOUTS.REMOTE_PACKAGE};try{a=await fetchWithTimeout(e,{referrerPolicy:"no-referrer"},r)}catch(e){const t=s[e.code];throw t&&(e.message=t),e}try{i=await a.json()}catch(t){throw new Error(`Error parsing ${this.type} manifest data from ${e}: ${t.message}`)}return new this(i,{installed:!1,strict:t})}static async fromRepository(e){const{packages:t}=await this.getRepositoryPackages();return t.get(e)||null}static fromRepositoryData(e,s){return new this(t.#s(e,s),{installed:!1})}static#s(e,t){return{id:e.name,title:e.title,version:e.version.version,description:e.description,changelog:e.version.notes,authors:[{name:e.author}],url:e.url,manifest:e.version.manifest,protected:e.is_protected,compatibility:{minimum:e.version.required_core_version,verified:e.version.compatible_core_version,maximum:e.version.maximum_core_version},relationships:{systems:e.requires.map((e=>({id:e,type:"system"})))},tags:e.tags??[],exclusive:e.is_exclusive,owned:e.is_protected&&t.includes(e.id)}}static async install(e,s,i,a,{onError:r,onProgress:o,onFetched:n}={}){const c=await t.#i(e,i,{onError:r,onProgress:o,onFetched:n}),l=await t.#a(e,c,a,{onError:r,onProgress:o});if(!l)return;globalThis.packages.warnings.delete(e),this._addInstalledPackageToCache(e,l);const d=this.get(l.id);return d&&await t.#r(d,s),d}static async#r(e,t){const s=PACKAGE_TYPE_MAPPING[e.type],i=await s.fromRepository(e.id);const a=await async function(){return i||e.availability===PACKAGE_AVAILABILITY_CODES.VERIFIED||e.manifest===t?null:(await s.check(e.manifest,e)).remote}(),r=e.sidegrade(a,i);foundry.utils.isEmpty(r)||(e.availability=e.constructor.testAvailability(e))}static async#i(e,t,{onError:s,onProgress:i,onFetched:a}={}){const r=CONST.SETUP_PACKAGE_PROGRESS.STEPS,o=path.join(this.baseDir,`${e}.zip`),n=new FileDownloader(t,o);return s&&n.on("error",(e=>s(r.DOWNLOAD,e))),i&&n.on("progress",((e,t)=>i(r.DOWNLOAD,e,t))),a&&n.on("fetched",a),await n.download(),o}static async#a(e,t,s,{onError:i,onProgress:a}={}){const r=new PackageInstaller(this.type,this.baseDir,e,t,s);i&&r.on("error",(e=>i(CONST.SETUP_PACKAGE_PROGRESS.STEPS.INSTALL,e))),a&&r.on("progress",a);const o=await r.install();return globalThis.logger.info(`Installed ${this.type} ${e}`),o}static _addInstalledPackageToCache(e,t){if(!this.packages)return;const s=this.get(e);if(s)s.updateSource(t),s.availability=s.constructor.testAvailability(s);else{const t=path.join(this.baseDir,e,this.manifestFile),s=this.fromManifestPath(t);s&&this.packages.set(e,s)}for(const e of Object.values(PACKAGE_TYPE_MAPPING))e.reevaluateAvailabilities()}static async check(e,t,{strict:s=!0}={}){let i,a={remote:null,isUpgrade:!1,isDowngrade:!1,availability:PACKAGE_AVAILABILITY_CODES.UNKNOWN};try{i=await this.fromRemoteManifest(e,{strict:s}),a.remote=i}catch(e){return globalThis.logger.warn(e.message),a.error=e.message,e.code&&(a.errorCode=e.code),a}return a.isUpgrade=!t||isNewerVersion(i.version,t.version),a.isDowngrade=!!t&&isNewerVersion(t.version,i.version),a.availability=i.availability,a}suggestTrackChange(e){return e&&e.manifest&&e.version?e.manifest===this.manifest?null:isNewerVersion(e.version,this.version)?{manifest:e.manifest,version:e.version}:null:null}sidegrade(e,t){let s={};const i=(e,t,s)=>{const i=(e,t,s,i)=>{e[t]||(e[t]=deepClone(s)),isNewerVersion(s.minimum,i.minimum)&&(e[t].minimum=i.minimum),isNewerVersion(i.verified,s.verified)&&(e[t].verified=i.verified),isNewerVersion(i.maximum,s.maximum)&&(e[t].maximum=i.maximum)};for(const a of t){const t=e[a],r=this._source[a];switch(a){case"authors":t.map((e=>e.name)).equals(r.map((e=>e.name)))||(s[a]=t);break;case"minimumCoreVersion":isNewerVersion(r,t)&&(s[a]=t);break;case"compatibleCoreVersion":isNewerVersion(t,r)&&(s[a]=t);break;case"compatibility":case"systemCompatibility":i(s,a,r,t);break;default:r!==t&&(s[a]=t)}}};if(e&&i(e.toObject(),this.constructor.manifestMetadataFields,s),t&&t.version===e?.version){const e=["compatibility"];i(t.toObject(),e,s)}const a=this.updateSource(s);return isEmpty(a)?null:(this.installed&&this.save(),this.availability=this.constructor.testAvailability(this),globalThis.logger.info(`Applied sidegrade metadata updates to ${this.type} ${this.id}`),a)}static async uninstall(e){const t=this.get(e),s=path.join(this.baseDir,e);if(!fs.existsSync(s))throw new Error(`The package ${e} does not exist to uninstall!`);await fs.promises.rm(s,{force:!0,recursive:!0}),this.packages&&this.packages.delete(e),globalThis.logger.info(`Uninstalled ${this.type} ${e}`),globalThis.packages.warnings.delete(e);for(const e of Object.values(PACKAGE_TYPE_MAPPING))e.reevaluateAvailabilities();return t?.toObject()??{id:e}}static resetPackages(){this.packages=null}async lock(e){const t=path.join(this.path,`${this.id}.lock`);fs.existsSync(t)?(e||fs.unlinkSync(t),globalThis.logger.info(`Unlocked ${this.type} ${this.id}`)):(e&&fs.writeFileSync(t,"🔒"),globalThis.logger.info(`Locked ${this.type} ${this.id}`)),this.locked=e}save(e={}){const t=foundry.utils.mergeObject(this.toObject(),e),s=this.constructor.cleanData(),i=foundry.utils.diffObject(s,t),a=path.join(this.path,this.constructor.manifestFile);return Files.writeFileSyncSafe(a,JSON.stringify(i,null,2)),this}registerCustomSocket(e){if(!this.socket)return;const t=`${this.constructor.type}.${this.id}`;e.on(t,handleCustomSocket.bind(e,t))}static#o="https://foundryvtt.com/_api/packages/get";static#n="https://foundryvtt.com/_api/packages/auth";static#c=3e5;static#l={packages:new Map,owned:[],lastUpdated:0,request:void 0};static async getRepositoryPackages({release:e}={}){const s=!(e instanceof ReleaseData);s&&(e=config.release);const i=s?t.#l:{packages:new Map,owned:[],lastUpdated:0,request:void 0};if(i.request)return await i.request,i;const a=Date.now()-i.lastUpdated>=t.#c;return s&&!a||(i.packages.clear(),i.owned=[],i.request=new Promise((async s=>{let a,r;try{a=await fetchJsonWithTimeout(t.#o,{headers:{"Content-Type":"application/json",Authorization:config.license.authorizationHeader},method:"POST",body:JSON.stringify({type:this.type,version:e.version,license:config.license.data})},{timeoutMs:TIMEOUTS.PACKAGE_REPOSITORY}),(a.error||"error"===a.status)&&(r=a.error.message)}catch(e){r=`Could not get Repository Packages - ${e}`}if(r)return logger.error(r),i.packages=new Map,i.owned=[],s();const{packages:o,owned:n}=a;for(const e of o){let t;try{t=this.fromRepositoryData(e,n)}catch(t){logger.warn(`Received invalid Package data from website repository for package id "${e.name}"`)}t&&(i.packages.set(t.id,t),t.owned&&i.owned.push(t.id))}return i.lastUpdated=Date.now(),s()})),await i.request,i.request=void 0),i}static async getProtectedDownloadURL({type:e,id:s,version:i}={}){return await fetchJsonWithTimeout(t.#n,{headers:{"Content-Type":"application/json",Authorization:config.license.authorizationHeader},method:"POST",body:JSON.stringify({type:e,name:s,version:i,license:config.license.data})})}static#t(e,t){const s=global.config.license;let i=JSON.parse(fs.readFileSync(e,"utf-8"));const a="package"in i?{license:s.data.license,key:i.key,package:i.package,version:t}:{license:s.data.license,key:i.key,version:t},r=crypto.createVerify("SHA256");r.write(JSON.stringify(a));const o=crypto.createPublicKey(s.constructor.PUBLIC_KEY);if(!r.verify(o,i.signature,"base64"))throw new Error("Invalid signature")}};return t};export default ServerPackageMixin;export{PackageAssetField,ServerPackageMixin};